/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.RemoteJob;
import org.opensourcephysics.tools.Tool;

public class RemoteTool
extends UnicastRemoteObject
implements Tool {
    Tool child;
    Map<Job, Collection<Tool>> replies = new HashMap<Job, Collection<Tool>>();
    Map<Job, Job> jobs = new HashMap<Job, Job>();

    public RemoteTool(Tool tool) throws RemoteException {
        OSPLog.finest("Wrapping tool " + tool.getClass().getName());
        this.child = tool;
    }

    @Override
    public void send(Job job, Tool tool) throws RemoteException {
        this.save(job, tool);
        job = this.convert(job);
        if (this.child.equals(tool)) {
            this.sendReplies(job);
        } else {
            this.forward(job);
        }
    }

    private void save(Job job, Tool tool) {
        if (tool == null || this.child.equals(tool)) {
            return;
        }
        Collection<Tool> collection = this.replies.get(job);
        if (collection == null) {
            collection = new HashSet<Tool>();
            this.replies.put(job, collection);
        }
        collection.add(tool);
    }

    private void sendReplies(Job job) throws RemoteException {
        Collection<Tool> collection = this.replies.get(job);
        if (collection == null) {
            return;
        }
        for (Tool tool : collection) {
            tool.send(job, this);
        }
    }

    private void forward(Job job) throws RemoteException {
        this.child.send(job, this);
    }

    private Job convert(Job job) throws RemoteException {
        if (job instanceof LocalJob) {
            RemoteJob remoteJob = new RemoteJob(job);
            this.jobs.put(remoteJob, job);
            return remoteJob;
        }
        Job job2 = this.jobs.get(job);
        if (job2 == null) {
            return job;
        }
        return job2;
    }
}

