/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.SnapshotTool;

public class ImageFrame
extends OSPFrame {
    protected BufferedImage image;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenu saveImageMenu;
    protected JMenuItem copyItem;
    protected JMenuItem printItem;
    protected JMenuItem exitItem;
    protected JMenuItem epsItem;
    protected JMenuItem gifItem;
    protected JMenuItem jpgItem;
    protected JMenuItem pngItem;
    protected DrawingPanel drawingPanel = new DrawingPanel();
    protected static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected String chooserTitle;

    public ImageFrame(MeasuredImage measuredImage) {
        this.setContentPane(this.drawingPanel);
        this.drawingPanel.addDrawable(measuredImage);
        this.drawingPanel.setPreferredMinMax(measuredImage.getXMin(), measuredImage.getXMax(), measuredImage.getYMin(), measuredImage.getYMax());
        this.image = measuredImage.getImage();
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        this.drawingPanel.setPreferredSize(new Dimension(n + 1, n2 + 1));
        this.createMenuBar();
        this.pack();
        this.chooserTitle = DisplayRes.getString("GUIUtils.Title.SaveImage");
    }

    private void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu(DisplayRes.getString("DrawingFrame.File_menu_item"));
        this.printItem = new JMenuItem(DisplayRes.getString("ImageFrame.Print_menu_item"));
        this.printItem.setAccelerator(KeyStroke.getKeyStroke(80, MENU_SHORTCUT_KEY_MASK));
        this.printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintUtils.printComponent(ImageFrame.this.drawingPanel);
            }
        });
        this.saveImageMenu = new JMenu(DisplayRes.getString("ImageFrame.SaveAs_menu_item"));
        this.epsItem = new JMenuItem(DisplayRes.getString("DrawingFrame.EPS_menu_item"));
        this.gifItem = new JMenuItem(DisplayRes.getString("DrawingFrame.GIF_menu_item"));
        this.jpgItem = new JMenuItem(DisplayRes.getString("DrawingFrame.JPEG_menu_item"));
        this.pngItem = new JMenuItem(DisplayRes.getString("DrawingFrame.PNG_menu_item"));
        this.saveImageMenu.add(this.epsItem);
        this.saveImageMenu.add(this.gifItem);
        this.saveImageMenu.add(this.jpgItem);
        this.saveImageMenu.add(this.pngItem);
        this.epsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = DisplayRes.getString("ImageFrame.EPS_filter_description");
                String[] stringArray = new String[]{"eps", "EPS"};
                GUIUtils.saveImageAs(ImageFrame.this.drawingPanel, "eps", ImageFrame.this.chooserTitle, string, stringArray);
            }
        });
        this.gifItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = DisplayRes.getString("ImageFrame.GIF_filter_description");
                String[] stringArray = new String[]{"gif", "GIF"};
                GUIUtils.saveImageAs(ImageFrame.this.drawingPanel, "gif", ImageFrame.this.chooserTitle, string, stringArray);
            }
        });
        this.jpgItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = DisplayRes.getString("ImageFrame.JPEG_filter_description");
                String[] stringArray = new String[]{"jpg", "jpeg", "JPG", "JPEG"};
                GUIUtils.saveImageAs(ImageFrame.this.drawingPanel, "jpeg", ImageFrame.this.chooserTitle, string, stringArray);
            }
        });
        this.pngItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = DisplayRes.getString("ImageFrame.PNG_filter_description");
                String[] stringArray = new String[]{"png", "PNG"};
                GUIUtils.saveImageAs(ImageFrame.this.drawingPanel, "png", ImageFrame.this.chooserTitle, string, stringArray);
            }
        });
        if (OSPRuntime.applet == null) {
            this.fileMenu.add(this.saveImageMenu);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.printItem);
        }
        jMenuBar.add(this.fileMenu);
        this.editMenu = new JMenu(DisplayRes.getString("DrawingFrame.Edit_menu_title"));
        jMenuBar.add(this.editMenu);
        this.copyItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Copy_menu_item"));
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, MENU_SHORTCUT_KEY_MASK));
        this.copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BufferedImage bufferedImage = new BufferedImage(ImageFrame.this.drawingPanel.getWidth(), ImageFrame.this.drawingPanel.getHeight(), 5);
                Graphics graphics = bufferedImage.getGraphics();
                ImageFrame.this.drawingPanel.paint(graphics);
                graphics.dispose();
                SnapshotTool.getTool().copyImage(bufferedImage);
            }
        });
        this.editMenu.add(this.copyItem);
        this.setJMenuBar(jMenuBar);
        this.loadDisplayMenu();
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.AboutOSP_menu_item"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OSPRuntime.showAboutDialog(ImageFrame.this);
            }
        });
        jMenu.add(jMenuItem);
    }

    @Override
    protected JMenu loadDisplayMenu() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Display_menu_title"));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
        jMenu.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelUp();
            }
        });
        jMenu2.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelDown();
            }
        });
        jMenu2.add(jMenuItem2);
        jMenu2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                jMenuItem2.setEnabled(FontSizer.getLevel() > 0);
            }
        });
        return jMenu;
    }
}

