/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Paint;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.VectorColorMapper;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementArrow;
import org.opensourcephysics.drawing2d.Group;
import org.opensourcephysics.drawing2d.Style;

public class VectorField
extends Group {
    protected double minimumX = Double.NaN;
    protected double maximumX = Double.NaN;
    protected double minimumY = Double.NaN;
    protected double maximumY = Double.NaN;
    protected double vectorSizeX = 1.0;
    protected double vectorSizeY = 1.0;
    protected double vectorAngle = Double.NaN;
    protected double vectorMagnitude = Double.NaN;
    protected double[][] vectorSizeXData;
    protected double[][] vectorSizeYData;
    protected double[][] vectorAngleData;
    protected double[][] vectorMagnitudeData;
    protected boolean autoscaleMagnitude = false;
    protected boolean useColorMapper = false;
    protected double constantLength = Double.NaN;
    protected int levels = -1;
    protected int invisibleLevel = -1;
    protected Color maxColor = Color.RED;
    protected Color minColor = Color.BLUE;
    private boolean positionChanged = true;
    private boolean sizeChanged = true;
    private boolean magChanged = true;
    protected double magConstant = 0.0;
    protected double minMagnitude = 0.0;
    protected double maxMagnitude = 1.0;
    protected double useMinX;
    protected double useMaxX;
    protected double useMinY;
    protected double useMaxY;
    protected Color[] colors;
    protected VectorColorMapper mapper = new VectorColorMapper(16, 1.0);
    protected double[][] vectorLength;
    protected int nX = -1;
    protected int nY = -1;
    private ElementArrow invisibleElement = new ElementArrow();
    private boolean showLegend;
    private int arrowType = 0;

    public VectorField() {
        this.addElement(this.invisibleElement);
        this.setNumberOfLevels(16);
    }

    public void setMinimumX(double d) {
        if (d != this.minimumX) {
            this.minimumX = d;
            this.positionChanged = true;
        }
    }

    public void setMaximumX(double d) {
        if (d != this.maximumX) {
            this.maximumX = d;
            this.positionChanged = true;
        }
    }

    public void setMinimumY(double d) {
        if (d != this.minimumY) {
            this.minimumY = d;
            this.positionChanged = true;
        }
    }

    public void setMaximumY(double d) {
        if (d != this.maximumY) {
            this.maximumY = d;
            this.positionChanged = true;
        }
    }

    public void setVectorSizeXData(double[][] dArray) {
        this.vectorSizeXData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeX(double d) {
        if (this.vectorSizeX != d) {
            this.vectorSizeX = d;
            this.sizeChanged = true;
        }
    }

    public void setVectorSizeYData(double[][] dArray) {
        this.vectorSizeYData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeY(double d) {
        if (this.vectorSizeY != d) {
            this.vectorSizeY = d;
            this.sizeChanged = true;
        }
    }

    public void setVectorAngleData(double[][] dArray) {
        this.vectorAngleData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorAngle(double d) {
        if (this.vectorAngle != d) {
            this.vectorAngle = d;
            this.sizeChanged = true;
        }
    }

    public void setConstantLength(double d) {
        if (this.constantLength != d) {
            this.constantLength = d;
            this.sizeChanged = true;
        }
    }

    public void setAutoscaleMagnitude(boolean bl) {
        if (this.autoscaleMagnitude != bl) {
            this.autoscaleMagnitude = bl;
            this.magChanged = true;
        }
    }

    public void setMagnitudeExtrema(double d, double d2) {
        if (this.autoscaleMagnitude) {
            this.autoscaleMagnitude = false;
            this.magChanged = true;
        }
        if (this.minMagnitude == d && this.maxMagnitude == d2) {
            return;
        }
        this.minMagnitude = d;
        this.maxMagnitude = d2;
        if (this.maxMagnitude == this.minMagnitude) {
            this.maxMagnitude = this.minMagnitude + 1.0;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setScale(this.maxMagnitude);
        this.mapper.updateLegend();
        this.magChanged = true;
    }

    public double getMagnitudeMinimum() {
        return this.minMagnitude;
    }

    public double getMagnitudeMaximum() {
        return this.maxMagnitude;
    }

    public void setMagnitudeData(double[][] dArray) {
        this.vectorMagnitudeData = dArray;
        this.magChanged = true;
        this.checkArrays();
    }

    public void setMagnitude(double d) {
        if (this.vectorMagnitude != d) {
            this.vectorMagnitude = d;
            this.magChanged = true;
        }
    }

    public void setNumberOfLevels(int n) {
        if (n == this.levels) {
            return;
        }
        this.magChanged = true;
        if (n <= 0) {
            this.levels = 0;
            return;
        }
        this.levels = n;
        this.colors = new Color[this.levels];
        this.initColors();
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setNumberOfColors(this.levels);
        this.mapper.updateLegend();
    }

    public void setMinColor(Color color) {
        if (color.equals(this.minColor)) {
            return;
        }
        this.minColor = color;
        this.initColors();
        this.magChanged = true;
    }

    public void setMaxColor(Color color) {
        if (color.equals(this.maxColor)) {
            return;
        }
        this.maxColor = color;
        this.initColors();
        this.magChanged = true;
    }

    public void setInvisibleLevel(int n) {
        if (this.invisibleLevel != n) {
            this.invisibleLevel = n;
            this.magChanged = true;
        }
    }

    public void setArrowType(int n) {
        this.arrowType = n;
        for (Element element : this.getElements()) {
            ((ElementArrow)element).setArrowType(n);
        }
    }

    public void setRelativePosition(int n) {
        for (Element element : this.getElements()) {
            element.getStyle().setRelativePosition(n);
        }
    }

    public void setUseColorMapper(boolean bl) {
        this.useColorMapper = bl;
        this.setShowLegend(this.showLegend);
        this.mapper.updateLegend();
        this.magChanged = true;
    }

    public void setMapperPaletteType(int n) {
        this.mapper.setPaletteType(n);
    }

    public VectorColorMapper getColorMapper() {
        return this.mapper;
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
        JFrame jFrame = this.mapper.getLegendFrame();
        if (jFrame == null) {
            jFrame = this.mapper.showLegend();
        }
        jFrame.setVisible(this.useColorMapper && bl);
    }

    public double indexToX(int n) {
        if (n < 0 || n >= this.nX) {
            return Double.NaN;
        }
        this.checkExtrema();
        if (this.nX == 1) {
            return (this.useMinX + this.useMaxX) / 2.0;
        }
        return this.useMinX + (double)n * (this.useMaxX - this.useMinX) / (double)(this.nX - 1);
    }

    public double indexToY(int n) {
        if (n < 0 || n >= this.nY) {
            return Double.NaN;
        }
        this.checkExtrema();
        if (this.nY == 1) {
            return (this.useMinY + this.useMaxY) / 2.0;
        }
        return this.useMinY + (double)n * (this.useMaxY - this.useMinY) / (double)(this.nY - 1);
    }

    @Override
    public boolean isMeasured() {
        if (Double.isNaN(this.minimumX) || Double.isNaN(this.maximumX) || Double.isNaN(this.minimumY) || Double.isNaN(this.maximumY)) {
            return false;
        }
        return this.canBeMeasured;
    }

    @Override
    public double getXMin() {
        return this.minimumX;
    }

    @Override
    public double getXMax() {
        return this.maximumX;
    }

    @Override
    public double getYMin() {
        return this.minimumY;
    }

    @Override
    public double getYMax() {
        return this.maximumY;
    }

    @Override
    public double getXMinLogscale() {
        return this.minimumX > 0.0 ? this.minimumX : Double.NaN;
    }

    @Override
    public double getXMaxLogscale() {
        return this.maximumX > 0.0 ? this.maximumX : Double.NaN;
    }

    @Override
    public double getYMinLogscale() {
        return this.minimumY > 0.0 ? this.minimumY : Double.NaN;
    }

    @Override
    public double getYMaxLogscale() {
        return this.maximumY > 0.0 ? this.maximumY : Double.NaN;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.prepareField()) {
            super.draw(drawingPanel, graphics);
        }
    }

    private void checkExtrema() {
        DrawingPanel drawingPanel = (DrawingPanel)this.getPanel().getComponent();
        this.useMinX = Double.isNaN(this.minimumX) ? drawingPanel.getPreferredXMin() : this.minimumX;
        this.useMaxX = Double.isNaN(this.maximumX) ? drawingPanel.getPreferredXMax() : this.maximumX;
        this.useMinY = Double.isNaN(this.minimumY) ? drawingPanel.getPreferredYMin() : this.minimumY;
        this.useMaxY = Double.isNaN(this.maximumY) ? drawingPanel.getPreferredYMax() : this.maximumY;
    }

    private void checkArraySize(double[][] dArray) {
        if (dArray != null) {
            this.nX = Math.min(this.nX, dArray.length);
            this.nY = Math.min(this.nY, dArray[0].length);
        }
    }

    private boolean checkArrays() {
        int n;
        this.nY = Integer.MAX_VALUE;
        this.nX = Integer.MAX_VALUE;
        this.checkArraySize(this.vectorSizeXData);
        this.checkArraySize(this.vectorSizeYData);
        this.checkArraySize(this.vectorAngleData);
        this.checkArraySize(this.vectorMagnitudeData);
        if (this.nX == Integer.MAX_VALUE) {
            this.nX = 0;
        }
        if (this.nY == Integer.MAX_VALUE) {
            this.nY = 0;
        }
        if (this.nX <= 0 || this.nY <= 0) {
            return false;
        }
        if (this.vectorLength == null || this.vectorLength.length != this.nX || this.vectorLength[0].length != this.nY) {
            this.vectorLength = new double[this.nX][this.nY];
        }
        if ((n = this.nX * this.nY) != this.getElements().size() - 1) {
            this.setNumberOfElements(n);
        }
        return true;
    }

    private boolean isAngleSet() {
        return this.vectorAngleData != null || !Double.isNaN(this.vectorAngle);
    }

    private boolean isMagnitudeSet() {
        return this.vectorMagnitudeData != null || !Double.isNaN(this.vectorMagnitude);
    }

    private void setNumberOfElements(int n) {
        Style style = this.invisibleElement.getStyle();
        this.removeAllElements();
        this.addElement(this.invisibleElement);
        int n2 = 1;
        while (n2 <= n) {
            ElementArrow elementArrow = new ElementArrow();
            style.copyTo(elementArrow);
            elementArrow.setArrowType(this.arrowType);
            this.addElementAtIndex(n2, elementArrow);
            ++n2;
        }
        this.magChanged = true;
        this.sizeChanged = true;
        this.positionChanged = true;
    }

    public boolean prepareField() {
        double d;
        if (!this.isReallyVisible()) {
            return false;
        }
        if (this.nX <= 0 || this.nY <= 0) {
            return false;
        }
        if (this.sizeChanged) {
            int n;
            if (this.vectorSizeXData != null || this.vectorSizeYData != null || !this.isAngleSet()) {
                int n2;
                int n3;
                if (Double.isNaN(this.constantLength)) {
                    d = this.vectorSizeX;
                    double d2 = this.vectorSizeY;
                    n = 0;
                    n3 = 1;
                    while (n < this.nX) {
                        n2 = 0;
                        while (n2 < this.nY) {
                            if (this.vectorSizeXData != null) {
                                d = this.vectorSizeXData[n][n2];
                            }
                            if (this.vectorSizeYData != null) {
                                d2 = this.vectorSizeYData[n][n2];
                            }
                            this.vectorLength[n][n2] = Math.sqrt(d * d + d2 * d2);
                            this.getElement(n3).setSizeXY(d, d2);
                            ++n2;
                            ++n3;
                        }
                        ++n;
                    }
                } else {
                    d = this.vectorSizeX;
                    double d3 = this.vectorSizeY;
                    n = 0;
                    n3 = 1;
                    while (n < this.nX) {
                        n2 = 0;
                        while (n2 < this.nY) {
                            double d4;
                            if (this.vectorSizeXData != null) {
                                d = this.vectorSizeXData[n][n2];
                            }
                            if (this.vectorSizeYData != null) {
                                d3 = this.vectorSizeYData[n][n2];
                            }
                            if ((d4 = (this.vectorLength[n][n2] = Math.sqrt(d * d + d3 * d3))) == 0.0) {
                                d3 = 0.0;
                                d = 0.0;
                            } else {
                                d4 = this.constantLength / d4;
                                d *= d4;
                                d3 *= d4;
                            }
                            this.getElement(n3).setSizeXY(d, d3);
                            ++n2;
                            ++n3;
                        }
                        ++n;
                    }
                }
            } else {
                d = this.vectorAngle;
                int n4 = 0;
                int n5 = 1;
                while (n4 < this.nX) {
                    n = 0;
                    while (n < this.nY) {
                        if (this.vectorAngleData != null) {
                            d = this.vectorAngleData[n4][n];
                        }
                        this.vectorLength[n4][n] = this.constantLength;
                        this.getElement(n5).setSizeXY(this.constantLength * Math.cos(d), this.constantLength * Math.sin(d));
                        ++n;
                        ++n5;
                    }
                    ++n4;
                }
            }
            if (!this.isMagnitudeSet()) {
                this.magChanged = true;
            }
        }
        d = this.useMinX;
        double d5 = this.useMaxX;
        double d6 = this.useMinY;
        double d7 = this.useMaxY;
        this.checkExtrema();
        if (this.positionChanged || d != this.useMinX || d5 != this.useMaxX || d6 != this.useMinY || d7 != this.useMaxY) {
            double d8;
            double d9;
            double d10;
            double d11;
            if (this.nX <= 1) {
                d11 = (this.useMinX + this.useMaxX) / 2.0;
                d10 = 0.0;
            } else {
                d11 = this.useMinX;
                d10 = (this.useMaxX - this.useMinX) / (double)(this.nX - 1);
            }
            if (this.nY <= 1) {
                d9 = (this.useMinY + this.useMaxY) / 2.0;
                d8 = 0.0;
            } else {
                d9 = this.useMinY;
                d8 = (this.useMaxY - this.useMinY) / (double)(this.nY - 1);
            }
            int n = 0;
            int n6 = 1;
            while (n < this.nX) {
                double d12 = d11 + (double)n * d10;
                int n7 = 0;
                while (n7 < this.nY) {
                    this.getElement(n6).setXY(d12, d9 + (double)n7 * d8);
                    ++n7;
                    ++n6;
                }
                ++n;
            }
        }
        if (this.magChanged) {
            this.processMagnitude();
        }
        this.magChanged = false;
        this.sizeChanged = false;
        this.positionChanged = false;
        this.invisibleElement.setVisible(false);
        return true;
    }

    private void processMagnitude() {
        Object object;
        Component component = this.getPanel().getComponent();
        if (component instanceof PlottingPanel) {
            this.mapper.checkPallet(((PlottingPanel)component).getAxes().getInteriorBackground());
        } else {
            this.mapper.checkPallet(component.getBackground());
        }
        if (this.levels > 0) {
            double[][] dArray = object = this.isMagnitudeSet() ? this.vectorMagnitudeData : this.vectorLength;
            if (object != null) {
                if (this.autoscaleMagnitude) {
                    this.computeMagnitudeExtrema((double[][])object);
                }
                int n = 0;
                int n2 = 1;
                while (n < this.nX) {
                    int n3 = 0;
                    while (n3 < this.nY) {
                        Element element = this.getElement(n2);
                        double d = object[n][n3];
                        Color color = this.magToColor(d);
                        if (color == null) {
                            element.setVisible(false);
                        } else {
                            element.setVisible(true);
                            element.getStyle().setLineColor(color);
                            element.getStyle().setFillColor(color);
                            element.getStyle().setExtraColor(this.magToCompColor(d));
                        }
                        ++n3;
                        ++n2;
                    }
                    ++n;
                }
                return;
            }
        }
        object = Double.isNaN(this.vectorMagnitude) ? this.minColor : this.magToColor(this.vectorMagnitude);
        Color color = Double.isNaN(this.vectorMagnitude) ? this.maxColor : this.magToCompColor(this.vectorMagnitude);
        int n = 0;
        int n4 = 1;
        while (n < this.nX) {
            int n5 = 0;
            while (n5 < this.nY) {
                Element element = this.getElement(n4);
                element.setVisible(true);
                element.getStyle().setLineColor((Color)object);
                element.getStyle().setFillColor((Paint)object);
                element.getStyle().setExtraColor(color);
                ++n5;
                ++n4;
            }
            ++n;
        }
    }

    private void computeMagnitudeExtrema(double[][] dArray) {
        if (dArray == null) {
            return;
        }
        this.minMagnitude = Double.POSITIVE_INFINITY;
        this.maxMagnitude = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < dArray.length) {
            double[] dArray2 = dArray[n];
            int n2 = 0;
            while (n2 < dArray2.length) {
                this.minMagnitude = Math.min(this.minMagnitude, dArray2[n2]);
                this.maxMagnitude = Math.max(this.minMagnitude, dArray2[n2]);
                ++n2;
            }
            ++n;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setScale(this.maxMagnitude);
        this.mapper.updateLegend();
    }

    private void initColors() {
        int n = this.minColor.getRed();
        int n2 = this.minColor.getGreen();
        int n3 = this.minColor.getBlue();
        int n4 = this.minColor.getAlpha();
        int n5 = this.maxColor.getRed();
        int n6 = this.maxColor.getGreen();
        int n7 = this.maxColor.getBlue();
        int n8 = this.maxColor.getAlpha();
        int n9 = 0;
        while (n9 < this.levels) {
            int n10 = (int)((float)n + (float)((n5 - n) * n9) * 1.0f / (float)(this.levels - 1));
            int n11 = (int)((float)n2 + (float)((n6 - n2) * n9) * 1.0f / (float)(this.levels - 1));
            int n12 = (int)((float)n3 + (float)((n7 - n3) * n9) * 1.0f / (float)(this.levels - 1));
            int n13 = (int)((float)n4 + (float)((n8 - n4) * n9) * 1.0f / (float)(this.levels - 1));
            this.colors[n9] = new Color(n10, n11, n12, n13);
            ++n9;
        }
    }

    private Color magToColor(double d) {
        if (this.useColorMapper) {
            return this.mapper.doubleToColor(d);
        }
        if (this.colors == null || this.levels == 0) {
            return this.minColor;
        }
        int n = (int)(this.magConstant * (d - this.minMagnitude));
        if (this.invisibleLevel >= 0 && n <= this.invisibleLevel) {
            return null;
        }
        if (n <= 0) {
            return this.colors[0];
        }
        if (n >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[n];
    }

    private Color magToCompColor(double d) {
        if (this.useColorMapper) {
            return this.mapper.doubleToCompColor(d);
        }
        if (this.colors == null || this.levels == 0) {
            return this.maxColor;
        }
        int n = (int)(this.magConstant * (this.maxMagnitude - d));
        if (this.invisibleLevel >= 0 && n <= this.invisibleLevel) {
            return null;
        }
        if (n <= 0) {
            return this.colors[0];
        }
        if (n >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[n];
    }
}

