/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ElementImage
extends Element {
    private String imageFile = null;
    private boolean trueSize = false;
    private Resource resource = null;
    private Image image = null;
    private double[] coordinates = new double[2];
    private double[] pixel = new double[2];
    private double[] pixelSize = new double[2];
    private AffineTransform imageTransform = new AffineTransform();
    private AffineTransform trueSizeTransform = new AffineTransform();
    private Shape shape;
    private double tempSizeX;
    private double tempSizeY;

    public ElementImage() {
        this.setSize(new double[]{0.1, 0.1});
        this.setImageFile("/org/opensourcephysics/resources/controls/images/window.gif");
    }

    private void setTheImage(Image image, int n) {
        double d;
        double d2;
        int n2;
        int n3;
        this.image = image;
        if (this.image == null) {
            return;
        }
        int n4 = Math.max(this.image.getWidth(null), 1);
        int n5 = Math.max(this.image.getHeight(null), 1);
        switch (n) {
            default: {
                n3 = -n4 / 2;
                n2 = -n5 / 2;
                break;
            }
            case 1: {
                n3 = -n4 / 2;
                n2 = 0;
                break;
            }
            case 2: {
                n3 = -n4 / 2;
                n2 = -n5;
                break;
            }
            case 3: {
                n3 = -n4;
                n2 = -n5 / 2;
                break;
            }
            case 4: {
                n3 = 0;
                n2 = -n5 / 2;
                break;
            }
            case 5: {
                n3 = -n4;
                n2 = 0;
                break;
            }
            case 6: {
                n3 = 0;
                n2 = 0;
                break;
            }
            case 7: {
                n3 = -n4;
                n2 = -n5;
                break;
            }
            case 8: {
                n3 = 0;
                n2 = -n5;
            }
        }
        this.imageTransform = AffineTransform.getScaleInstance(1.0 / (double)n4, -1.0 / (double)n5);
        this.imageTransform.concatenate(AffineTransform.getTranslateInstance(n3, n2));
        switch (n) {
            default: {
                d2 = -0.5;
                d = -0.5;
                break;
            }
            case 1: {
                d2 = -0.5;
                d = -1.0;
                break;
            }
            case 2: {
                d2 = -0.5;
                d = 0.0;
                break;
            }
            case 3: {
                d2 = -1.0;
                d = -0.5;
                break;
            }
            case 4: {
                d2 = 0.0;
                d = -0.5;
                break;
            }
            case 5: {
                d2 = -1.0;
                d = -1.0;
                break;
            }
            case 6: {
                d2 = 0.0;
                d = -1.0;
                break;
            }
            case 7: {
                d2 = -1.0;
                d = 0.0;
                break;
            }
            case 8: {
                d2 = 0.0;
                d = 0.0;
            }
        }
        this.shape = new Rectangle2D.Double(d2, d, 1.0, 1.0);
        this.setNeedToProject(true);
    }

    public void setImageFile(String string) {
        if (this.imageFile != null && this.imageFile.equals(string)) {
            return;
        }
        this.imageFile = string;
        if (string != null) {
            this.resource = ResourceLoader.getResource(string);
            if (this.resource != null) {
                this.image = this.resource.getImage();
                Component component = null;
                if (this.getPanel() != null) {
                    component = this.getPanel().getComponent();
                }
                Toolkit.getDefaultToolkit().prepareImage(this.image, -1, -1, component);
                this.setTheImage(this.resource.getImage(), this.getStyle().getRelativePosition());
            }
        }
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImage(Image image) {
        this.imageFile = null;
        if (image != this.image) {
            this.image = image;
            Component component = null;
            if (this.getPanel() != null) {
                component = this.getPanel().getComponent();
            }
            Toolkit.getDefaultToolkit().prepareImage(this.image, -1, -1, component);
            this.setTheImage(image, this.getStyle().getRelativePosition());
            if (this.trueSize) {
                this.setTrueSize(true);
            }
        }
    }

    public void setTrueSize(boolean bl) {
        this.trueSize = bl;
        if (this.trueSize) {
            this.tempSizeX = this.getSizeX();
            this.tempSizeY = this.getSizeY();
            if (this.image != null) {
                super.setSizeXY(this.image.getWidth(null), this.image.getHeight(null));
            }
        } else {
            super.setSizeXY(this.tempSizeX, this.tempSizeY);
        }
        this.setNeedToProject(true);
    }

    public boolean isTrueSize() {
        return this.trueSize;
    }

    @Override
    public void setSizeX(double d) {
        if (this.trueSize) {
            this.tempSizeX = d;
            this.setElementChanged();
        } else {
            super.setSizeX(d);
        }
    }

    @Override
    public void setSizeY(double d) {
        if (this.trueSize) {
            this.tempSizeY = d;
            this.setElementChanged();
        } else {
            super.setSizeY(d);
        }
    }

    @Override
    public void setSizeXY(double d, double d2) {
        if (this.trueSize) {
            this.tempSizeX = d;
            this.tempSizeY = d2;
            this.setElementChanged();
        } else {
            super.setSizeXY(d, d2);
        }
    }

    @Override
    public void setSize(double[] dArray) {
        if (this.trueSize) {
            this.tempSizeX = dArray[0];
            this.tempSizeY = dArray[0];
            this.setElementChanged();
        } else {
            super.setSize(dArray);
        }
    }

    @Override
    protected void styleChanged(int n) {
        if (n == 5) {
            this.setTheImage(this.image, this.getStyle().getRelativePosition());
        }
    }

    @Override
    protected int getCorners(double[] dArray) {
        if (this.trueSize) {
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return 1;
        }
        switch (this.getStyle().getRelativePosition()) {
            default: {
                dArray[0] = -0.5;
                dArray[1] = -0.5;
                break;
            }
            case 1: {
                dArray[0] = -0.5;
                dArray[1] = -1.0;
                break;
            }
            case 2: {
                dArray[0] = -0.5;
                dArray[1] = 0.0;
                break;
            }
            case 3: {
                dArray[0] = -1.0;
                dArray[1] = -0.5;
                break;
            }
            case 4: {
                dArray[0] = 0.0;
                dArray[1] = -0.5;
                break;
            }
            case 5: {
                dArray[0] = -1.0;
                dArray[1] = -1.0;
                break;
            }
            case 6: {
                dArray[0] = 0.0;
                dArray[1] = -1.0;
                break;
            }
            case 7: {
                dArray[0] = -1.0;
                dArray[1] = 0.0;
                break;
            }
            case 8: {
                dArray[0] = 0.0;
                dArray[1] = 0.0;
            }
        }
        dArray[4] = dArray[2] = dArray[0] + 1.0;
        dArray[6] = dArray[0];
        dArray[3] = dArray[1];
        dArray[5] = dArray[7] = dArray[1] + 1.0;
        return 4;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        AffineTransform affineTransform;
        if (this.image == null || !this.isReallyVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.trueSize) {
            if (this.hasChanged() || this.needsToProject()) {
                this.projectPoints();
            }
            affineTransform = new AffineTransform(this.trueSizeTransform);
            affineTransform.preConcatenate(this.getPixelTransform(drawingPanel));
        } else {
            affineTransform = this.getPixelTransform(drawingPanel);
        }
        affineTransform.concatenate(this.imageTransform);
        graphics2D.drawImage(this.image, affineTransform, drawingPanel);
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        int n3;
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        if (this.image == null || !this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        if ((n3 = this.getStyle().getSensitivity()) <= 0) {
            AffineTransform affineTransform;
            if (this.trueSize) {
                affineTransform = new AffineTransform(this.trueSizeTransform);
                affineTransform.preConcatenate(this.getPixelTransform(drawingPanel));
            } else {
                affineTransform = this.getPixelTransform(drawingPanel);
            }
            Shape shape = affineTransform.createTransformedShape(this.shape);
            if (shape.contains(n, n2)) {
                return this.targetPosition;
            }
        } else if (Math.abs(this.pixel[0] - (double)n) < (double)n3 && Math.abs(this.pixel[1] - (double)n2) < (double)n3) {
            return this.targetPosition;
        }
        return null;
    }

    private void projectPoints() {
        if (this.image == null) {
            return;
        }
        this.coordinates[0] = 0.0;
        this.coordinates[1] = 0.0;
        this.getTotalTransform().transform(this.coordinates, 0, this.coordinates, 0, 1);
        this.getPanel().projectPosition(this.coordinates, this.pixel);
        if (this.trueSize) {
            int n = this.image.getWidth(null);
            int n2 = this.image.getHeight(null);
            this.getPanel().projectSize(this.coordinates, this.getSize(), this.pixelSize);
            this.trueSizeTransform = AffineTransform.getScaleInstance(this.pixelSize[0] == 0.0 ? 0.0 : (double)n / this.pixelSize[0], this.pixelSize[1] == 0.0 ? 0.0 : (double)n2 / this.pixelSize[1]);
        }
        this.setNeedToProject(false);
    }
}

