/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Dimension;
import java.awt.Graphics;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractPolarAxis;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.PolarAxes;

public class PolarType1
extends AbstractPolarAxis
implements PolarAxes,
Dimensioned {
    public PolarType1(PlottingPanel plottingPanel, String string, String string2, double d) {
        super(plottingPanel);
        this.defaultLeftGutter = 25;
        this.defaultTopGutter = 25;
        this.defaultRightGutter = 25;
        this.defaultBottomGutter = 25;
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        if (plottingPanel == null) {
            return;
        }
        plottingPanel.setPreferredGutters(this.defaultLeftGutter, this.defaultTopGutter, this.defaultRightGutter, this.defaultBottomGutter);
        plottingPanel.setAxes(this);
        plottingPanel.setCoordinateStringBuilder(CoordinateStringBuilder.createPolar(string, string2, d));
        plottingPanel.setClipAtGutter(false);
    }

    public PolarType1(PlottingPanel plottingPanel) {
        this(plottingPanel, "r=", " phi=", 0.0);
    }

    @Override
    public Dimension getInterior(DrawingPanel drawingPanel) {
        double d = Math.abs(drawingPanel.getPreferredXMax());
        d = Math.max(d, Math.abs(drawingPanel.getPreferredXMin()));
        d = Math.max(d, Math.abs(drawingPanel.getPreferredYMax()));
        d = Math.max(d, Math.abs(drawingPanel.getPreferredYMin()));
        drawingPanel.setPreferredMinMax(-d, d, -d, d, false);
        return null;
    }

    @Override
    public void setXLabel(String string, String string2) {
    }

    @Override
    public void setYLabel(String string, String string2) {
    }

    @Override
    public String getXLabel() {
        return "";
    }

    @Override
    public String getYLabel() {
        return "";
    }

    public void setXLog(boolean bl) {
    }

    public void setYLog(boolean bl) {
    }

    @Override
    public void setShowMajorXGrid(boolean bl) {
    }

    @Override
    public void setShowMinorXGrid(boolean bl) {
    }

    @Override
    public void setShowMajorYGrid(boolean bl) {
    }

    @Override
    public void setShowMinorYGrid(boolean bl) {
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        double d = Math.abs(drawingPanel.getPreferredXMax());
        double d2 = this.drawRings(d, drawingPanel, graphics);
        this.drawSpokes(d, drawingPanel, graphics);
        this.drawRAxis(d2, d, drawingPanel, graphics);
        this.titleLine.setX((drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0);
        if (drawingPanel.getTopGutter() > 20) {
            this.titleLine.setY(drawingPanel.getYMax() + 5.0 / drawingPanel.getYPixPerUnit());
        } else {
            this.titleLine.setY(drawingPanel.getYMax() - 25.0 / drawingPanel.getYPixPerUnit());
        }
        this.titleLine.setColor(drawingPanel.getForeground());
        this.titleLine.draw(drawingPanel, graphics);
    }
}

