/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.display.TeXParser;

public class DataRowModel
extends AbstractTableModel {
    ArrayList<Object> rowList = new ArrayList();
    ArrayList<String> colNames = new ArrayList();
    boolean rowNumberVisible = true;
    int colCount = 0;
    int maxRows = -1;
    int firstRowIndex = 0;
    int stride = 1;

    public DataRowModel() {
        this.colNames.add(0, "row");
    }

    public void setStride(int n) {
        this.stride = n;
    }

    public void setMaxPoints(int n) {
        this.maxRows = n;
        if (this.maxRows <= 0 || this.rowList.size() <= n) {
            return;
        }
        int n2 = 0;
        int n3 = this.rowList.size() - n;
        while (n2 < n3) {
            this.rowList.remove(0);
            ++n2;
        }
        this.colCount = 0;
        n2 = 0;
        n3 = this.rowList.size();
        while (n2 < n3) {
            Object object = this.rowList.get(n2);
            if (object.getClass().isArray()) {
                int n4 = 0;
                if (object instanceof double[]) {
                    n4 = ((double[])object).length;
                } else if (object instanceof byte[]) {
                    n4 = ((byte[])object).length;
                } else if (object instanceof int[]) {
                    n4 = ((int[])object).length;
                } else if (object instanceof String[]) {
                    n4 = ((String[])object).length;
                }
                this.colCount = Math.max(this.colCount, n4);
            }
            ++n2;
        }
    }

    public void clear() {
        this.rowList.clear();
        this.colCount = 0;
    }

    public synchronized void appendRow(Object object) throws IllegalArgumentException {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("A TableData row must be an array.");
        }
        Class<?> clazz = object.getClass().getComponentType();
        String string = clazz.getName();
        if (string.equals("double")) {
            this.appendDoubles((double[])object);
        } else if (string.equals("int")) {
            this.appendInts((int[])object);
        } else if (string.equals("byte")) {
            this.appendBytes((byte[])object);
        } else if (string.equals("string")) {
            this.appendStrings((String[])object);
        } else {
            Object[] objectArray = (Object[])object;
            String[] stringArray = new String[objectArray.length];
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                stringArray[n] = objectArray[n].toString();
                ++n;
            }
            this.appendStrings(stringArray);
        }
    }

    void appendDoubles(double[] dArray) {
        if (dArray == null) {
            return;
        }
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(dArray2);
        this.colCount = Math.max(this.colCount, dArray2.length + 1);
    }

    void appendInts(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(nArray2);
        this.colCount = Math.max(this.colCount, nArray2.length + 1);
    }

    void appendBytes(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(byArray2);
        this.colCount = Math.max(this.colCount, byArray2.length + 1);
    }

    void appendStrings(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        if (this.maxRows > 0 && this.rowList.size() >= this.maxRows) {
            this.rowList.remove(0);
        }
        this.rowList.add(stringArray2);
        this.colCount = Math.max(this.colCount, stringArray2.length + 1);
    }

    public boolean setRowNumberVisible(boolean bl) {
        if (this.rowNumberVisible == bl) {
            return false;
        }
        this.rowNumberVisible = bl;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean setColumnNames(int var1_1, String var2_2) {
        var2_2 = TeXParser.parseTeX(var2_2);
        if (this.colNames != null && (var1_1 >= this.colNames.size() || this.colNames.get(var1_1) == null || !this.colNames.get(var1_1).equals(var2_2))) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            this.colNames.add("" + (char)(65 + var1_1));
lbl6:
            // 2 sources

            ** while (var1_1 >= this.colNames.size())
        }
lbl7:
        // 1 sources

        this.colNames.set(var1_1, var2_2);
        return true;
    }

    public void setFirstRowIndex(int n) {
        this.firstRowIndex = n;
    }

    @Override
    public int getColumnCount() {
        int n;
        int n2 = n = this.rowNumberVisible ? 0 : 1;
        if (this.getRowCount() == 0) {
            return this.colNames == null ? 0 : this.colNames.size() - n;
        }
        int n3 = this.rowNumberVisible ? this.colCount : this.colCount - 1;
        return n3;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0 && this.rowNumberVisible) {
            return this.colNames.get(0);
        }
        if (!this.rowNumberVisible) {
            ++n;
        }
        if (n < this.colNames.size()) {
            return this.colNames.get(n);
        }
        return "" + (char)(65 + n - 1);
    }

    @Override
    public int getRowCount() {
        return (this.rowList.size() + this.stride - 1) / this.stride;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        n *= this.stride;
        if (n2 == 0 && this.rowNumberVisible) {
            return new Integer(n + this.firstRowIndex);
        }
        if (!this.rowNumberVisible) {
            ++n2;
        }
        if (n >= this.rowList.size()) {
            return "";
        }
        Object object = this.rowList.get(n);
        if (!object.getClass().isArray()) {
            return "";
        }
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            if (n2 > dArray.length) {
                return "";
            }
            return new Double(dArray[n2 - 1]);
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (n2 > byArray.length) {
                return "";
            }
            return new Byte(byArray[n2 - 1]);
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            if (n2 > nArray.length) {
                return "";
            }
            return new Integer(nArray[n2 - 1]);
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            if (n2 > stringArray.length) {
                return "";
            }
            return stringArray[n2 - 1];
        }
        return "";
    }
}

