/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

public class ControlTwoStateButton
extends ControlSwingElement {
    protected static final int TWO_STATE_ADDED = 13;
    protected static final int VARIABLE = 11;
    protected static final int SELECTED = 12;
    protected static final int MY_FOREGROUND = 19;
    protected static final int MY_BACKGROUND = 20;
    protected JButton button;
    private boolean variableLinked = false;
    private String imageFileOn = null;
    private String imageFileOff = null;
    private Icon iconOn = null;
    private Icon iconOff = null;
    private String textOn = "";
    private String textOff = "";
    private char mnemonicOn = (char)65535;
    private char mnemonicOff = (char)65535;
    private Color frgdOn = null;
    private Color frgdOff = null;
    private Color bkgdOn = null;
    private Color bkgdOff = null;
    protected BooleanValue internalValue = new BooleanValue(true);
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.button = new JButton();
        this.button.setText(this.textOn);
        this.frgdOn = this.frgdOff = this.button.getForeground();
        this.bkgdOn = this.bkgdOff = this.button.getBackground();
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final boolean bl = !ControlTwoStateButton.this.internalValue.value;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ControlTwoStateButton.this.updateGUI(bl);
                    }
                });
                ControlTwoStateButton.this.invokeActions(ControlTwoStateButton.this.internalValue.value ? 20 : 21);
                boolean bl2 = ControlTwoStateButton.this.internalValue.value = !ControlTwoStateButton.this.internalValue.value;
                if (ControlTwoStateButton.this.variableLinked) {
                    ControlTwoStateButton.this.variableChanged(11, ControlTwoStateButton.this.internalValue);
                    if (ControlTwoStateButton.this.isUnderEjs) {
                        ControlTwoStateButton.this.setFieldListValue(11, ControlTwoStateButton.this.internalValue);
                    }
                }
            }
        });
        return this.button;
    }

    @Override
    public void reset() {
        this.internalValue.value = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ControlTwoStateButton.this.updateGUI(ControlTwoStateButton.this.internalValue.value);
            }
        });
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("textOn");
            infoList.add("textOff");
            infoList.add("imageOn");
            infoList.add("imageOff");
            infoList.add("actionOn");
            infoList.add("actionOff");
            infoList.add("mnemonicOn");
            infoList.add("mnemonicOff");
            infoList.add("foregroundOff");
            infoList.add("backgroundOff");
            infoList.add("alignment");
            infoList.add("variable");
            infoList.add("selected");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("textOn")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (string.equals("textOff")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (string.equals("imageOn")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("imageOff")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("actionOn")) {
            return "Action CONSTANT";
        }
        if (string.equals("actionOff")) {
            return "Action CONSTANT";
        }
        if (string.equals("mnemonicOn")) {
            return "String  TRANSLATABLE";
        }
        if (string.equals("mnemonicOff")) {
            return "String  TRANSLATABLE";
        }
        if (string.equals("foregroundOff")) {
            return "Color|Object";
        }
        if (string.equals("backgroundOff")) {
            return "Color|Object";
        }
        if (string.equals("alignment")) {
            return "Alignment|int";
        }
        if (string.equals("variable")) {
            return "boolean";
        }
        if (string.equals("selected")) {
            return "boolean POSTPROCESS";
        }
        return super.getPropertyInfo(string);
    }

    private void updateGUI(boolean bl) {
        this.button.setText(bl ? this.textOn : this.textOff);
        this.button.setIcon(bl ? this.iconOn : this.iconOff);
        this.button.setMnemonic(bl ? this.mnemonicOn : this.mnemonicOff);
        this.button.setForeground(bl ? this.frgdOn : this.frgdOff);
        this.button.setBackground(bl ? this.bkgdOn : this.bkgdOff);
    }

    @Override
    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("variable")) {
            Value value;
            this.variableLinked = string2 == null ? false : (value = Value.parseConstant(string2, true)) == null;
        }
        return super.setProperty(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.textOn = TeXParser.parseTeX(value.getString());
                if (!this.internalValue.value) break;
                this.button.setText(this.textOn);
                break;
            }
            case 1: {
                this.textOff = TeXParser.parseTeX(value.getString());
                if (this.internalValue.value) break;
                this.button.setText(this.textOff);
                break;
            }
            case 2: {
                if (value.getString().equals(this.imageFileOn)) {
                    return;
                }
                this.imageFileOn = value.getString();
                this.iconOn = this.getIcon(this.imageFileOn);
                if (!this.internalValue.value) break;
                this.button.setIcon(this.iconOn);
                break;
            }
            case 3: {
                if (value.getString().equals(this.imageFileOff)) {
                    return;
                }
                this.imageFileOff = value.getString();
                this.iconOff = this.getIcon(this.imageFileOff);
                if (this.internalValue.value) break;
                this.button.setIcon(this.iconOff);
                break;
            }
            case 4: {
                this.removeAction(20, this.getProperty("actionOn"));
                this.addAction(20, value.getString());
                break;
            }
            case 5: {
                this.removeAction(21, this.getProperty("actionOff"));
                this.addAction(21, value.getString());
                break;
            }
            case 6: {
                this.mnemonicOn = value.getString().charAt(0);
                if (!this.internalValue.value) break;
                this.button.setMnemonic(this.mnemonicOn);
                break;
            }
            case 7: {
                this.mnemonicOff = value.getString().charAt(0);
                if (this.internalValue.value) break;
                this.button.setMnemonic(this.mnemonicOff);
                break;
            }
            case 8: {
                if (!(value.getObject() instanceof Color)) break;
                this.frgdOff = (Color)value.getObject();
                if (this.internalValue.value) break;
                this.button.setForeground(this.frgdOff);
                break;
            }
            case 9: {
                if (!(value.getObject() instanceof Color)) break;
                this.bkgdOff = (Color)value.getObject();
                if (this.internalValue.value) break;
                this.button.setBackground(this.bkgdOff);
                break;
            }
            case 10: {
                this.button.setHorizontalAlignment(value.getInteger());
                break;
            }
            case 11: {
                this.internalValue.value = value.getBoolean();
                this.updateGUI(this.internalValue.value);
                break;
            }
            case 12: {
                this.updateGUI(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 13, value);
                break;
            }
            case 19: {
                if (!(value.getObject() instanceof Color)) break;
                this.frgdOn = (Color)value.getObject();
                if (!this.internalValue.value) break;
                this.button.setForeground(this.frgdOn);
                break;
            }
            case 20: {
                if (!(value.getObject() instanceof Color)) break;
                this.bkgdOn = (Color)value.getObject();
                if (!this.internalValue.value) break;
                this.button.setBackground(this.bkgdOn);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.textOn = "";
                if (!this.internalValue.value) break;
                this.button.setText(this.textOn);
                break;
            }
            case 1: {
                this.textOff = "";
                if (this.internalValue.value) break;
                this.button.setText(this.textOff);
                break;
            }
            case 2: {
                this.imageFileOn = null;
                this.iconOn = null;
                if (!this.internalValue.value) break;
                this.button.setIcon(this.iconOn);
                break;
            }
            case 3: {
                this.imageFileOff = null;
                this.iconOff = null;
                if (this.internalValue.value) break;
                this.button.setIcon(this.iconOff);
                break;
            }
            case 4: {
                this.removeAction(20, this.getProperty("actionOn"));
                break;
            }
            case 5: {
                this.removeAction(21, this.getProperty("actionOff"));
                break;
            }
            case 6: {
                this.mnemonicOn = (char)65535;
                if (!this.internalValue.value) break;
                this.button.setMnemonic(this.mnemonicOn);
                break;
            }
            case 7: {
                this.mnemonicOff = (char)65535;
                if (this.internalValue.value) break;
                this.button.setMnemonic(this.mnemonicOff);
                break;
            }
            case 8: {
                this.frgdOff = this.myDefaultFrgd;
                if (this.internalValue.value) break;
                this.button.setForeground(this.frgdOff);
                break;
            }
            case 9: {
                this.bkgdOff = this.myDefaultBkgd;
                if (this.internalValue.value) break;
                this.button.setBackground(this.bkgdOff);
                break;
            }
            case 10: {
                this.button.setHorizontalAlignment(0);
                break;
            }
            case 11: {
                this.internalValue.value = true;
                this.updateGUI(this.internalValue.value);
                break;
            }
            case 12: {
                this.updateGUI(true);
                break;
            }
            default: {
                super.setDefaultValue(n - 13);
                break;
            }
            case 19: {
                this.frgdOn = this.myDefaultFrgd;
                if (!this.internalValue.value) break;
                this.button.setForeground(this.frgdOn);
                break;
            }
            case 20: {
                this.bkgdOn = this.myDefaultBkgd;
                if (!this.internalValue.value) break;
                this.button.setBackground(this.bkgdOn);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "<none>";
            }
            case 4: 
            case 5: {
                return "<no_action>";
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "<none>";
            }
            case 10: {
                return "CENTER";
            }
            case 11: {
                return "true";
            }
            case 12: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 13);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                return null;
            }
            case 11: {
                return this.internalValue;
            }
        }
        return super.getValue(n - 13);
    }
}

